#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Julia - hw5Mod01.fsh  by  Morevita  
//https://www.shadertoy.com/view/l3KXDG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265

vec3 palette(float t, vec3 a, vec3 b, vec3 c, vec3 d) {
    return a + b * cos(6.28318 * (c * t + d));
}

float getAngularDist(float angle1, float angle2) {
    float angle = angle1 - angle2;
    if (angle > PI) {
        angle -= 2.0 * PI;
    } else if (angle <= -PI) {
        angle += 2.0 * PI;
    }
    return angle;
 }

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   
    vec2 uv = (fragCoord - 0.5 * iResolution.xy) / iResolution.y;

    float zoom =.7 + 0.65 * sin(iTime * 0.2);
    vec2 offset = vec2(0.0, 0.0);
    uv = uv * zoom + offset;
    uv *= mat2(cos(iTime/10.), -sin(iTime/10.), -sin( iTime/10.), -cos(iTime/10.));

    vec2 c = vec2(-0.7, 0.27015);
    vec2 z = uv;
    int iterations = 200;
    float threshold = 2.0;

    for (int i = 0; i < iterations; i++) {
        float x = (z.x * z.x - z.y * z.y) + c.x;
        float y = (z.y * z.x + z.x * z.y) + c.y;
        z = vec2(x, y);

        if (length(z) > threshold) {
            float angleO = atan(uv.y, uv.x);
            float angleT = atan(z.y, z.x);

            float eDist = length(uv - z);
            float aDist = getAngularDist(angleO, angleT);
            aDist = aDist / (2. * PI);

            // Define the color palette
            vec3 colA = vec3(0.0, 0.2, 0.6); 
            vec3 colB = vec3(0.4, 0.7, 0.8); 
            vec3 colC = vec3(0.1, 0.2, 0.9); 
            vec3 colD = vec3(0.1, 0.6, 0.0); 

            // Use smoothstep to interpolate the colors
            vec3 color = mix(colA, colB, smoothstep(0.0, 0.2, aDist));
            color = mix(color, colC, smoothstep(0.2, 0.66, aDist));
            color = mix(color, colD, smoothstep(0.66, 1.0, aDist));

            fragColor = vec4(color, 1.0);
            return fragColor;
 
       }
   }

    fragColor = vec4(1., 1., 1., 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
//vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

